﻿var MobileOfflineLogsTable = {
    context: $(".v-MobileOfflineLogsTable"),
    datatable: null,
    refreshDataTable: function () {
        MobileOfflineLogsTable.datatable.a4datatable("refresh");
    },
    initializeDataTable: function () {
        this.datatable = $(".h-MobileOfflineLogsTable", MobileOfflineLogsTable.context).a4datatable({
            height: "full",
            stateKey: "MobileOfflineLogsTable",
            ajaxAction: a4.getAction("GetMobileOfflineLogs", "Diagnostics", "Settings"),
            columns: [
                { "Name": "Id", "Title": resources.Id, "Data": "Id", "Class": "id", "Width": "60px", "Key": true },
                //{ "Name": "CreateDate", "Title": resources.CreateDate, "Data": "CreateDate", "Type": "date", "Width": "130px" },
                { "Name": "UserName", "Title": resources.UserName, "Data": "UserName"  },
                { "Name": "Type", "Title": resources.Type, "Data": "Type", "Type": "enum", "EnumType": "MobileOfflineLogType" },
                { "Name": "FileName", "Title": resources.File, "Data": "FileName" },
                { "Name": "FileDate", "Title": resources.FileDate, "Data": "FileDate", "Type": "datetime", "Width": "130px" },
                { "Name": "DeviceModel", "Title": resources.DeviceModel, "Data": "DeviceModel" },
            ],
            localizableTexts: { "Search": resources.SearchVMOLogs },
            displayLength: 10,
            toolBarItems: MobileOfflineLogsTable.getToolBarItems(),
            defaultSorting: { Column: "Id", Ascending: false },
            advancedFilter: true,
            contextMenuItems: MobileOfflineLogsTable.getContextMenuItems(),
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = []; 
                for (var i = 0; i < rows.length; i++) {
                    ids.push(rows[i].Id);
                } 
                switch (action) {
                    case "DownloadMultiple":
                           MobileOfflineLogsTable.DownloadMultipleFileLog(ids);
                        break; 
                }
            },
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;
                var id = [row.Id];

                var ids = [];  
                    ids.push(row.Id); 

                switch (action) {
                    case "View":
                        modalDialog.showWindow(a4.getAction("MobileOfflineLogsFileContent", "Diagnostics", "Settings", { id: row.Id }), 600, 800, { afterClose: function () { MobileOfflineLogsTable.refreshDataTable(); } });
                        break;
                    case "Download":
                        MobileOfflineLogsTable.downloadFileLog(ids);
                        break; 
                }
            },
        });

    },
    bindEvents: function () {
        MobileOfflineLogsTable.context.on("click", ".h-exportLogs", function () {
            var tableParams = MobileOfflineLogsTable.datatable.a4datatable("getTableParams");
            var link = a4.getAction("ExportMobileOfflineLogs", "Diagnostics", "Settings", { tableParams: JSON.stringify(tableParams) });

            a4.showBusyBox();

            a4.callServerMethod(link, {},
            function (result) {
                a4.hideBusyBox();
                window.location = a4.getAction("GetMobileOfflineLogsFile", "Diagnostics", "Settings", {  filename: result });
            });
        });

        //MobileOfflineLogsTable.context.on("click", ".h-clearLogs", function () {
        //    modalDialog.showConfirmDialog(confirmClearLogsResources, function () {
        //        a4.callServerMethod(a4.getAction("ClearMobileOfflineLogsTable", "Diagnostics", "Settings"), {},
        //            function (result) {
        //                MobileOfflineLogsTable.refreshDataTable();
        //            });
        //    }, 220, 500);
        //});
    },

    getContextMenuItems: function () {
        var items = []; 
            items = [
                { "Action": "View", "Label": resources.ViewDetail },
                { "Divider": true },
                { "Action": "Download", "Label": resources.Download },
            ]  
        return items;
    }, 
    downloadFileLog: function (items) {   
        var link = a4.getAction("DownloadMobileOfflineLogsFile", "Diagnostics", "Settings", { ids: items.join(",") });

        a4.showBusyBox();

        a4.callServerMethod(link, {},
        function (result) {
             a4.hideBusyBox();
            if (result.success) { 
                window.location = a4.getAction("GetMobileOfflineLogsFile", "Diagnostics", "Settings", { filename: result.fileName });
            }
            else
                a4.showErrorMessage(result.message);
        });
    },
    DownloadMultipleFileLog: function (items) { 
        var link = a4.getAction("DownloadMobileOfflineLogsFile", "Diagnostics", "Settings", { ids: items.join(",") });

        a4.showBusyBox();

        a4.callServerMethod(link, {},
        function (result) {
             a4.hideBusyBox();
            if (result.success) { 
                window.location = a4.getAction("GetMobileOfflineLogsFile", "Diagnostics", "Settings", { filename: result.fileName });
            }
            else
                a4.showErrorMessage(result.message);
          
        });
    },
    getToolBarItems: function () {
        var items = [];
        items = [
            { "Action": "DownloadMultiple", "Label": resources.Download },
        ]
        return items;
    }
}

$(document).ready(function () {
    if (MobileOfflineLogsTable.context.length > 0) {
        MobileOfflineLogsTable.initializeDataTable();
        MobileOfflineLogsTable.bindEvents();
    }
});


